#!/usr/bin/python

import sys
import time
import dbus

bus = dbus.SystemBus()

manager = dbus.Interface(bus.get_object("org.bluez", "/"),
						"org.bluez.Manager")

adapter = dbus.Interface(bus.get_object("org.bluez", manager.DefaultAdapter()),
							"org.bluez.Adapter")

if (len(sys.argv) < 2):
	print "Usage: %s <address> [service]" % (sys.argv[0])
	sys.exit(1)

address = sys.argv[1]

if (len(sys.argv) < 3):
	service = "spp"
else:
	service = sys.argv[2]

path = adapter.FindDevice(address)

serial = dbus.Interface(bus.get_object("org.bluez", path),
						"org.bluez.Serial")

node = serial.Connect(service)

print "Connected %s to %s" % (device, address)

print "Press CTRL-C to disconnect"

try:
	time.sleep(1000)
	print "Terminating connection"
except:
	pass

serial.Disconnect(node)
