#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

from terra.core.controller import Controller
from terra.ui.modal import ModalMessage
from terra.core.manager import Manager

mger = Manager()
BasicPanel = mger.get_class("Widget/BasicPanel")


class PanelController(Controller):
    terra_type = "Controller/Panel"

    def use(self, model, end_callback=None):
        self.parent.use(model, end_callback)

    def back(self, end_callback=None):
        self.parent.back(end_callback)


class BasicPanelController(PanelController):
    terra_type = "Controller/BasicPanel"

    def __init__(self, model, canvas, parent):
        PanelController.__init__(self, model, canvas, parent)
        self._setup_view()

    def _setup_view(self):
        self.view = BasicPanel(self.parent.window, self.model.title)
        self.view.callback_escape = self.back

    def inner_contents_set(self, contents):
        self.view.inner_contents_set(contents)

    def delete(self):
        self.view.delete()
        self.view = None


class ModalController(Controller):
    terra_type = "Controller/Modal"

    def back(self, end_callback=None):
        self.parent.back(end_callback)


class ModalMessageController(ModalController):
    def __init__(self, model, canvas, parent, message):
        ModalController.__init__(self, model, canvas, parent)

        self.view = ModalMessage(parent.last_panel.view, message,
                                 hborder=16, vborder=100)
        self.view.callback_escape = self.close
        self.view.callback_clicked = self.close
        self.callback_leave = None
        self.view.show()

    def close(self):
        def cb(*ignored):
            self.back(self.callback_leave)
        self.view.hide(end_callback=cb)

    def delete(self):
        self.view.delete()
        self.view = None
