/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "wlanacmevent.h"

DEFINE_EVENT_TYPE(EVT_WLAN_ACM)

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
WlanAcmEvent::WlanAcmEvent(unsigned int id, unsigned long code, unsigned long error)
        : wxEvent(id, EVT_WLAN_ACM)
        , m_nCode(code)
        , m_nError(error)
{
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
WlanAcmEvent::~WlanAcmEvent()
{
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
wxEvent* WlanAcmEvent::Clone() const
{
    return new WlanAcmEvent(*this);
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
unsigned long WlanAcmEvent::GetEventCode() const
{
    return m_nCode;
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
unsigned long WlanAcmEvent::GetErrorCode() const
{
    return m_nError;
}
