/*
 * Copyright (C) 2010 Freescale Semiconductor, Inc. All rights reserved.
 *
 */
 
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    mfw_gst_buffer.h
 *
 * Description:    Gstreamer buffer management based on hardware.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 *
 */

/*=============================================================================
                                INCLUDE FILES
=============================================================================*/

#ifndef _MFW_GST_BUFFER_H_
#define _MFW_GST_BUFFER_H_


G_BEGIN_DECLS

GType mfw_gst_buffer_get_type (void);

#define MFW_GST_TYPE_BUFFER (mfw_gst_buffer_get_type())
#define MFW_GST_IS_BUFFER(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MFW_GST_TYPE_BUFFER))
#define MFW_GST_BUFFER(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST ((obj), MFW_GST_TYPE_BUFFER, MFWGstBuffer))
#define MFW_GST_BUFFER_GET_CLASS(obj)  \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), MFW_GST_TYPE_BUFFER, MFWGstBufferClass))

typedef struct _MFWGstBuffer MFWGstBuffer;
typedef struct _MFWGstBufferClass MFWGstBufferClass;

struct _MFWGstBuffer {
    GstBuffer buffer;
    void  * priv;
};

MFWGstBuffer *mfw_gst_buffer_new(GstElement * obj, int size);


G_END_DECLS

#endif				/* _MFW_GST_BUFFER_H_ */
