/*
 * Copyright (C) 2008-2009 Freescale Semiconductor, Inc. All rights reserved.
 *
 */
 
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    mfw_gst_radec.h
 *
 * Description:    Head file for RealMedia audio decoder plugin for 
 *                 Gstreamer.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 * Sep 04 2008 Sario HU <b01138@freescale.com>
 * - Initial version
 *
 */



/*=============================================================================
                            INCLUDE FILES
=============================================================================*/

#ifndef __MFW_GST_RADEC_H__
#define __MFW_GST_RADEC_H__

/*=============================================================================
                                           CONSTANTS
=============================================================================*/

/* None. */

/*=============================================================================
                                             ENUMS
=============================================================================*/

/* None. */

/*=============================================================================
                                            MACROS
=============================================================================*/
G_BEGIN_DECLS
#define MFW_GST_TYPE_RADEC \
  (mfw_gst_radec_get_type())
#define MFW_GST_RADEC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),MFW_GST_TYPE_RADEC,\
   MFW_GST_RADEC_INFO_T))
#define MFW_GST_RADEC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),MFW_GST_TYPE_RADEC,MFW_GST_RADEC_CLASS_T))
#define MFW_GST_IS_RADEC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),MFW_GST_TYPE_RADEC))
#define MFW_GST_IS_RADEC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),MFW_GST_TYPE_RADEC))
/*=============================================================================
                                 STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/

#ifdef PUSH_MODE
typedef struct _blocktimestamp{
    struct _blocktimestamp * next;
    guint buflen;
    GstClockTime timestamp;
}Block_Timestamp;

typedef struct _timestampmanager{
    Block_Timestamp * allocatedbuffer;
    Block_Timestamp * freelist;
    Block_Timestamp * head;
    Block_Timestamp * tail;
    guint  allocatednum; 
}Timestamp_Manager;
#endif

typedef struct {
    gint Flavor; 
    gint nSamples;
    gint nChannels;
    gint nRegions;
    gint nFrameBits;
    gint sampRate;
    gint cplStart;
    gint cplQbits;
}FlavorParameter;


typedef struct MFW_GST_RADEC_INFO_S {
    GstElement element;
    GstPad *sinkpad;
    GstPad *srcpad;
    gboolean init_done;		/* flag to check whether the initialisation 
				   is done or not */
    gboolean flow_error;        /* flag to indicate a fatal flow error */
    GstBuffer *inbuffer1;	/* input buffer */
    GstBuffer *inbuffer2;	/* addition input buffer used for the  
				   call back */
    gboolean caps_set;		/* flag to check whether the source pad 
				   capabilities  are set or not */
    gboolean eos;		/* flag to update end of stream staus */
    gboolean seek_flag;		/* flag to check whether seek is in demuxer or in decoder  */
    guint64  time_offset;	/* time increment of the output  */
    guint64 sampling_freq;
    gint bit_rate;
    guint32 number_of_channels;
    guint64 total_frames;
    gint64 total_time;
    guint bitsPerFrame;
    guint SampFreqIdx;
    gint nBitsReceive;
    gint nFramesReceived;
    gint bitstream_count;
    gint bitstream_buf_index;
    gint in_buf_done;
gint nBitsReceived;
    guint64 buffer_time;
    gboolean corrupt_bs;
#ifdef PUSH_MODE    
    GstAdapter * pAdapter;
    Timestamp_Manager tsMgr;
#endif  
    gint sampleperframe;
    gint flavorindex;
    FlavorParameter * opt;
    Gecko2_Decoder_Config * decoder_config;
    int codedelay;

    gint demo_mode; /* 0: Normal mode, 1: Demo mode 2: Demo ending */
#ifdef MEMORY_DEBUG
    Mem_Mgr memmgr;
#endif

} MFW_GST_RADEC_INFO_T;


typedef struct MFW_GST_RADEC_CLASS_S {
    GstElementClass parent_class;
} MFW_GST_RADEC_CLASS_T;


/*=============================================================================
                                 GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                                     FUNCTION PROTOTYPES
=============================================================================*/

GType mfw_gst_radec_get_type(void);

G_END_DECLS
/*===========================================================================*/
#endif				/* __MFW_GST_RADEC_H__ */
