/*
 * Copyright 2005-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * Based on gstasfdemux.h by Erik Walthinsen <omega@cse.ogi.edu>.
 */


/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    mfw_gst_asfdemuxer_plugin.h
 *
 * Description:    Head file for asf demuxer gstreamer plugin.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 *
 */

#ifndef MFW_GST_ASF_DEMUXER_H
#define MFW_GST_ASF_DEMUXER_H


G_BEGIN_DECLS

/*=============================================================================
                                INCLUDE FILES
=============================================================================*/

/*=============================================================================
                                 CONSTANTS
=============================================================================*/

/*=============================================================================
                                 MACROS
=============================================================================*/

/**** Presently only 1 Audio and 1 Video stream is considered ****/
#define ASF_MAX_STREAMS				2


#define MFW_GST_TYPE_ASF_DEMUXER (mfw_gst_type_asfdemuxer_get_type())
#define MFW_GST_ASF_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),MFW_GST_TYPE_ASF_DEMUXER,\
  MFWGstAsfDemux))
#define MFW_GST_ASF_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),MFW_GST_TYPE_ASF_DEMUXER,\
  MFWGstAsfDemux))
#define MFW_GST_IS_ASF_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),MFW_GST_TYPE_ASF_DEMUXER))
#define MFW_GST_IS_ASF_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),MFW_GST_TYPE_ASF_DEMUXER)),
/*=============================================================================
                                             ENUMS
=============================================================================*/
    typedef enum {
    MFW_ASF_MEDIA_AUDIO_TRACK = 0,
    MFW_ASF_MEDIA_VIDEO_TRACK
} MFW_ASF_MEDIA_TYPE_T;

/*=============================================================================
                                 STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/
typedef struct _asf_stream_context {
    guint num;			/* index of this stream */
    GstPad *src_pad;
    gchar *name;

} asf_stream_context;

typedef struct _MFWGstAsfDemux {
    GstElement element;
    GstPad *sinkpad;
    ASF_HANDLE asf_handle;	/* stream information */
    gboolean init_parser;
    GstState state;
    guint num_streams;		/* total number of streams */
    gboolean audio_present;
    gboolean video_present;
    gboolean for_audio_first_time;
    gboolean for_video_first_time;
    gboolean send_newseg;
    asf_stream_context asf_stream[ASF_MAX_STREAMS];
    guint64 total_duration;
    guint64 seeked_time;
    guint64 byte_rate;
    guint64 packet_size;
    simple_index_object asf_index_object;
    GstSegment segment;
    GstSegment seek_segment;
    gboolean have_seek_segment;
    gboolean seekable;
    gboolean is_seeking;
    asf_parser_stream *op_stream;
    asf_parser_file_properties asf_file_prop;
    gboolean task_paused;
} MFWGstAsfDemux;

typedef struct _MFWGstAsfDemuxClass {
    GstElementClass parent_class;
} MFWGstAsfDemuxClass;



/*=============================================================================
                                 GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                                     FUNCTION PROTOTYPES
=============================================================================*/

GType mfw_gst_type_asfdemuxer_get_type(void);

/*===========================================================================*/

G_END_DECLS
#endif	/*_MFW_GST_ASF_DEMUXER_H*/
