/*
 * Copyright (C) 2005-2009 Freescale Semiconductor, Inc. All rights reserved.
 *
 */
 
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    mfw_gst_avi_demuxer.h
 *
 * Description: This Header file contains all the declarations 
 *              of avi Demuxer Plugin for GStreamer.                         
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 *
 */

/*=============================================================================
                            INCLUDE FILES
=============================================================================*/
#include "common/fsl_types.h"
#include "common/file_stream.h"
#include "common/fsl_media_types.h"
#include "common/fsl_parser.h"
#include "avi_parser_v2/avi_parser_api.h"

#ifndef _MFW_GST_AVI_DEMUXER_H
#define _MFW_GST_AVI_DEMUXER_H


/* drm divx support definition */
#define MFW_AVI_SUPPORT_DIVX_DRM
#define MONO 1
#define STEREO 2

#define LIMIT_MAX_AVI_SAMPLESIZE   (1024*512)
#define DEFAULT_MAX_AVI_SAMPLESIZE (8192*4)
#define DEFAULT_MIN_AVI_SAMPLESIZE 1024
#define AVI_BITMAPINFOSIZE             40

/* below used to indicate totally how many usr data items need to trace */
#define AVI_USRDATA_NUM       16
#define AVI_REMAIN_THUNK_DATA_SIZE (10*1024)

#define u32 guint32
#define u64 guint64
#define u8  guint8
/*=============================================================================
                              CONSTANTS
=============================================================================*/

/* None. */

/*=============================================================================
                               ENUMS
=============================================================================*/
/* None */

/*=============================================================================
                               MACROS
=============================================================================*/

#define MAX_SRC_PADS  2
#define MAX_TRACK_NUM MAX_AVI_TRACKS
G_BEGIN_DECLS
#define MFW_GST_TYPE_AVI_DEMUXER (mfw_gst_type_avi_demuxer_get_type())
#define MFW_GST_AVI_DEMUXER(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST((obj), MFW_GST_TYPE_AVI_DEMUXER, MFW_GST_AVIDEMUX_INFO_T))
#define MFW_GST_AVI_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), MFW_GST_TYPE_AVI_DEMUXER, MFW_GST_AVIDEMUX_INFO_CLASS_T))
#define MFW_GST_IS_AVI_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MFW_GST_TYPE_AVI_DEMUXER))
#define MFW_GST_IS_AVI_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), MFW_GST_TYPE_AVI_DEMUXER))
/*=============================================================================
                            STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/
/*  This structure is used by the parser library to give information to the plug-in.
    This structure contains lot of variables which are similar to the above strcture, 
    but the reason why this is separate is because we wanted to maintain clean interface
    between parser library and the gstreamer plug-in.
*/

typedef struct _avi_input_file_info {
    guint64 length;		                               /* Length of the file/buffer */
    guint64 offset;	                                   /* Present location.         */
    guint64 buf_offset;

} avi_input_file_info;

typedef struct {
    GstBuffer * gstbuf;          /* gstbuffer used to get sample */
    gint offset;                 /* offset to no used space in gstbuf */
    gint cachesize;              /* default allocate size of gstbuf */
}AVIPadCache;

typedef struct{
	guint32 id;                   /* title, artist etc */
	guint8 *data_ptr;
	guint32 data_size;           /* data size in byte */   
}AVI_UsrData;

typedef struct{
	gint32 trackindex;
	MediaType trackType;     /* used to indicate audio or video*/
}Pad2Trackindex;
typedef struct{
	gint32 audiotrack[MAX_TRACK_NUM];
	gint32 videotrack[MAX_TRACK_NUM];
	gint32 audio_track_num;
	gint32 video_track_num;
}TrackReorder;


typedef struct 
{
    MediaType mediaType;
    gboolean isCbr;
    guint64 usSampleDuration;                /* sample duration for VBR stream. 0 for CBR stream*/
    guint32 bitrate;                         /* bitrate for CBR stream, 0 for VBR stream */
    guint32 maxSampleSize;

    guint64 usReadingDuration;               /* accumulated duration of samples */
    guint32 sampleCount;
    gboolean eos; 

    VideoCodecType videoCodec;
    AudioCodecType audioCodec;
    guint32 width;
	guint32 height;
	double   video_framerate;
    guint32 numChannels;
    guint32 sampleRate;	
    guint32 bitRate;
	guint32 pcm_width;
	guint32 decoderType;
	guint32 decoderSubtype;
    guint32 language;                        /* three byte language code */
    GstBuffer *decoderSpecificInfo;
}Track;



typedef struct _MFW_GST_AVIDEMUX_INFO_T {
    GstElement element;		                            /* instance of base class      */
    GstPad *sinkpad;		                            /* sink pad of element         */
    GstPad *srcpad[MAX_SRC_PADS];	                    /* src pads for output data    */
    guint32 total_src_pad;	                            /* number of src pads          */
	guint32 total_tracks;                               /* total number of tracks      */
    avi_input_file_info file_info;	                    /* file information            */
    GstSegment segment;		                            /* configured play segment     */
    gboolean stop_request;	                            /* stop request flag           */
    gboolean new_seg_flag_video;
	gboolean new_seg_flag_audio;
    GstCaps *caps[MAX_SRC_PADS];	                    /* src pad capability          */
    GstBuffer *tmpbuf;		                            /* buffer to store block of 
				                                                 input data            */
    guint buf_size;		                                /* temparory buffer size       */
    guint8 *inbuff;
	gboolean seek_flag;
	gboolean eos_flag[MAX_SRC_PADS];
	GMutex *media_file_lock;//lock for v4ldevice operation
	gboolean do_seek_flag;
    gboolean videosent;
	Pad2Trackindex srcpadnum2trackindex[MAX_SRC_PADS];
    AVIPadCache padcache[MAX_SRC_PADS];                 /* srcpad cache control to use sub gstbuffer to improve buffer usage efficiency */
	/* below var added for avi version 2.0 */
	file_stream_t stream;
    AviMemoryOps memOps;
	AviDrmOps drmOps;
	AviParserHandle  parserHandle;
	void *context;
	gboolean protected;
	gboolean isRental;
    guint32 viewLimit;
    guint32 viewCount;	
    guint8 cgmsaSignal;
    guint8 acptbSignal;
    guint8 digitalProtectionSignal; 
	Track tracks[MAX_AVI_TRACKS];
	gboolean seekable;
    guint64 usDuration;	
    guint32 minutes;
    guint32 seconds;
	AVI_UsrData usrdata[AVI_USRDATA_NUM];
	/* below two var used for configed audio or video track decode, default value is 0 */
    gint32  audio_track_decode;
    gint32  video_track_decode;	
	TrackReorder reorder_track;
    gchar *accurate_seek;	
	/* end for v2.0 avi parser adding */

} MFW_GST_AVIDEMUX_INFO_T;


typedef struct _MFW_GST_AVIDEMUX_INFO_CLASS_T {
    GstElementClass parent_class;

} MFW_GST_AVIDEMUX_INFO_CLASS_T;

/*=============================================================================
                           GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                            FUNCTION PROTOTYPES
=============================================================================*/
GType mfw_gst_type_avi_demuxer_get_type(void);

/*===========================================================================*/
G_END_DECLS
#endif /*_MFW_GST_AVI_DEMUXER_H*/