from gi.repository import GLib, Gtk, Pango, WebKit
import urllib, urllib2, json, urlparse, uuid
from oauth import oauth

from gwibber.microblog.util import resources
from gwibber.microblog.util.keyring import get_from_keyring
import gettext
from gettext import gettext as _
if hasattr(gettext, 'bind_textdomain_codeset'):
    gettext.bind_textdomain_codeset('gwibber','UTF-8')
gettext.textdomain('gwibber')

GLib.threads_init()

sigmeth = oauth.OAuthSignatureMethod_HMAC_SHA1()

CLIENT_ID = "BA0GOA0K3PTRS1KUJ5TTZ1P3GDRH3VJEEXY4N44ROPUJYKPW"
CLIENT_SECRET = "TS1LGTEZSJATQG22K5SXNASF021KPXI5LJTBQOVTX4JGOTYH"
REDIRECT_URI = "http://gwibber.com/0/auth.html"

class AccountWidget(Gtk.VBox):
  """AccountWidget: A widget that provides a user interface for configuring foursquare accounts in Gwibber
  """
  
  def __init__(self, account=None, dialog=None):
    """Creates the account pane for configuring Foursquare accounts"""
    Gtk.VBox.__init__( self, False, 20 )
    self.ui = Gtk.Builder()
    self.ui.set_translation_domain ("gwibber")
    self.ui.add_from_file (resources.get_ui_asset("gwibber-accounts-foursquare.ui"))
    self.ui.connect_signals(self)
    self.vbox_settings = self.ui.get_object("vbox_settings")
    self.pack_start(self.vbox_settings, False, False, 0)
    self.show_all()

    self.account = account or {}
    self.dialog = dialog
    self.window = dialog.dialog
    has_secret_key = False
    if self.account.has_key("id"):
        has_secret_key = get_from_keyring(self.account['id'],
                                          'secret_token') is not None

    try:
      if self.account.has_key("access_token") and self.account.has_key("secret_token") and self.account.has_key("username") and has_secret_key and not self.dialog.condition:
        self.ui.get_object("hbox_foursquare_auth").hide()
        self.ui.get_object("foursquare_auth_done_label").set_label(_("%s has been authorized by Foursquare") % self.account["username"])
        self.ui.get_object("hbox_foursquare_auth_done").show()
      else:
        self.ui.get_object("hbox_foursquare_auth_done").hide()
        if self.dialog.ui:
          self.dialog.ui.get_object('vbox_create').hide()
    except:
      self.ui.get_object("hbox_foursquare_auth_done").hide()
      if self.dialog.ui:
        self.dialog.ui.get_object("vbox_create").hide()

  def console_message_cb (self, *args):
    return True

  def on_foursquare_auth_clicked(self, widget, data=None):
    """ When the Authorize button is clicked, the Foursquare authorisation window
    is loaded for the user to enter their credentials for authorisation
    Args:
      widget:
      data:
    """
    self.winsize = self.window.get_size()

    web = WebKit.WebView()
    web.get_settings().set_property("enable-plugins", False)
    web.get_settings().set_property("enable-developer-extras", False)
    web.connect("console-message", self.console_message_cb)
    web.load_html_string(_("<p>Please wait...</p>"), "file:///")
    
    url = 'https://foursquare.com/oauth2/authenticate?client_id=' + CLIENT_ID + '&response_type=code&display=touch&redirect_uri='+ REDIRECT_URI
 
    web.load_uri(url)
    web.connect("title-changed", self.on_foursquare_auth_title_change)

    self.scroll = Gtk.ScrolledWindow()
    self.scroll.set_size_request(500, 400)
    self.scroll.add(web)

    self.pack_start(self.scroll, True, True, 0)
    self.show_all()

    self.ui.get_object("vbox1").hide()
    self.ui.get_object("vbox_advanced").hide()
    self.dialog.infobar.set_message_type(Gtk.MessageType.INFO)

  def on_foursquare_auth_title_change(self, web=None, title=None, data=None):
    """ When the title of the authorisation window is changed, the user has entered their credentials
    and pressed login.  If login is successful, exchange the code obtained from Foursquare via the callback url for
    an access token.  This is used for authentication for all subsequnt calls to Foursquare
    The first thing to do is get the user's own information from Foursquare.
    Args:
      web:
      title:
      data:
    """
    saved = False
    if hasattr(self.dialog, "infobar_content_area"):
      for child in self.dialog.infobar_content_area.get_children(): child.destroy()
    self.dialog.infobar_content_area = self.dialog.infobar.get_content_area()
    self.dialog.infobar_content_area.show()

    if title.get_title() == "Success":
      message_label = Gtk.Label(_("Verifying"))
      message_label.set_use_markup(True)
      message_label.set_ellipsize(Pango.EllipsizeMode.END)
      self.dialog.infobar_content_area.add(message_label)
      self.dialog.infobar.show_all()
      self.scroll.destroy()
      
      #Get the code from the callback uri (it's formatted as http://gwibber.com/0/auth.html/?code=CODE)
      url = web.get_main_frame().get_uri()
      data = urlparse.parse_qs(url.split("?", 1)[1])
      self.code = data["code"][0]
      
      self.ui.get_object("vbox1").show()
      self.ui.get_object("vbox_advanced").show()

      #Exchange the code for an access token
      url = "https://foursquare.com/oauth2/access_token?client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET + "&grant_type=authorization_code&redirect_uri=" + REDIRECT_URI + "&code=" + self.code
      self.access_token = json.load(urllib2.urlopen(url))['access_token']
      self.account["access_token"] = self.access_token
      self.account["secret_token"] = self.access_token
      
      #Make a request with our new token for the user's own data
      url = "https://api.foursquare.com/v2/users/self?oauth_token=" + self.access_token
      data = json.load(urllib2.urlopen(url))
      fullname = ""
      if data["response"]["user"].has_key("firstName"):
         fullname += data["response"]["user"]["firstName"] + " "
      if data["response"]["user"].has_key("lastName"):
        fullname += data["response"]["user"]["lastName"]
      self.account["username"] = fullname.encode("utf-8")
      self.account["user_id"] = data["response"]["user"]["id"]

      if isinstance(data, dict):
        data = data["response"]["user"]
        if data.has_key("id"):
          saved = self.dialog.on_edit_account_save()
        else:
          print "Failed"
          self.dialog.infobar.set_message_type(Gtk.MessageType.ERROR)
          message_label.set_text(_("Authorization failed. Please try again.")) 
      else:
        print "Failed"
        self.dialog.infobar.set_message_type(Gtk.MessageType.ERROR)
        message_label.set_text(_("Authorization failed. Please try again."))

      if saved: 
        message_label.set_text(_("Successful"))
        self.dialog.infobar.set_message_type(Gtk.MessageType.INFO)
        #self.dialog.infobar.hide()

      self.ui.get_object("hbox_foursquare_auth").hide()
      self.ui.get_object("foursquare_auth_done_label").set_label(_("%s has been authorized by Foursquare") % str(self.account["username"]))
      self.ui.get_object("hbox_foursquare_auth_done").show()
      if self.dialog.ui and self.account.has_key("id") and not saved:
        self.dialog.ui.get_object("vbox_save").show()
      elif self.dialog.ui and not saved:
        self.dialog.ui.get_object("vbox_create").show()

      self.window.resize(*self.winsize)

    if title.get_title() == "Failure":
      self.dialog.infobar.set_message_type(Gtk.MessageType.ERROR)
      message_label = Gtk.Label(_("Authorization failed. Please try again."))
      message_label.set_use_markup(True)
      message_label.set_ellipsize(Pango.EllipsizeMode.END)
      self.dialog.infobar_content_area.add(message_label)
      self.dialog.infobar.show_all()

      self.ui.get_object("vbox1").show()
      self.ui.get_object("vbox_advanced").show()
      self.scroll.destroy()
      self.window.resize(*self.winsize)

