/*
 * Compile with:
 *
 * valac --pkg glib-2.0 --pkg gtk+-2.0 --pkg dbus-glib-1 --pkg dee-1.0 --pkg json-glib-1.0 messages-model.vala -o messages-model 
 */

public class Master
{
  private Dee.Model model;
  private Dee.SharedModel shared_model;
  private Gwibber.Streams streams_service;

  public Master ()
  {
    streams_service = new Gwibber.Streams();
    streams_service.is_available.connect((is_up) => {
      if (is_up && !(this.model is Dee.Model))
      {
        this.model = streams_service.stream_model;
        this.shared_model = new Dee.SharedModel.with_back_end ("com.Gwibber.Streams.Model", this.model);
      }
    });
  }
}

public static int main (string[] args)
{
  Master master;
  
  master = new Master ();

  Gtk.main ();

  return 0;
}
