/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Messaging Framework.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QMAILSERVICECONFIGURATION_H
#define QMAILSERVICECONFIGURATION_H

#include <qmailaccountconfiguration.h>
#include <QString>


class MESSAGESERVER_EXPORT QMailServiceConfiguration
{
public:
    enum ServiceType { Unknown = 0, Source, Sink, SourceAndSink, Storage };

    QMailServiceConfiguration(QMailAccountConfiguration *config, const QString &service);
    QMailServiceConfiguration(const QMailAccountConfiguration &config, const QString &service);
    QMailServiceConfiguration(const QMailAccountConfiguration::ServiceConfiguration &config);

    ~QMailServiceConfiguration();

    QString service() const;
    QMailAccountId id() const;

    int version() const;
    void setVersion(int version);

    ServiceType type() const;
    void setType(ServiceType type);

    bool isValid() const;
    bool isEmpty() const;

    QString value(const QString &name, const QString &defaultValue = QString()) const;
    void setValue(const QString &name, const QString &value);

protected:
    static QString encodeValue(const QString &value);
    static QString decodeValue(const QString &value);

private:
    QMailAccountConfiguration::ServiceConfiguration *_config;
};


#endif
