/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          IPCController.h

Description:

    This file defines class IPCController.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef IPCONTROLLER_H_
#define IPCONTROLLER_H_

#include <dbus/dbus.h>
#include <string>
#include <list>
#include <pthread.h>
#include "IPCCommon.h"
#include "IntfData.h"

#define MESSAGE_OBJ_NAME "/neusoft/message/object"

namespace IPCAPI
{
	class IPCAPIBase;

	class IPCController
	{
	protected:
		IPCController(std::string strBusName,std::string strMatch);
		IPCController(const IPCController&);
      IPCController& operator= (const IPCController&);

	public:
		virtual ~IPCController();

	private:
		static IPCController* m_Instance;
		std::list<IPCAPIBase*> m_objIPCAPIList;
		std::list<IPCAPIBase*> m_NewAPIList;
		DBusConnection* m_DbusConn;
		DBusError m_DubsErr;
		DBusMessage* m_CurMsg;
		bool m_IsStart;
		char * m_BusName ;
		char *m_pMathcName;
		pthread_t m_thread;
		static void* ControllerWorkerProc(void* arg);
		bool m_SyncCallOn;
		pthread_mutex_t m_SyncConnectionLock;
		pthread_mutex_t m_APIQLock;
	private:
		bool Initial();
		APIResult SetBusName(std::string strBusName);
		APIResult AddMatch(std::string strMatch);

		APIResult SaftReturn(APIResult result);
	public:
		static IPCController* CreateInstance(std::string strBusName = "",std::string strMatch = "");
		static void Release();
		//		static APIResult RemoveAPI(IPCAPIBase* objAPI);

	public:
		bool End();
		bool IsStart();
		bool Start();
		APIResult SetAPI(IPCAPIBase* objAPI);
		APIResult SendMsg(std::string ServerName,std::string InterfaceName, std::string MsgName, std::string inArgs, std::string& outArgs);
		APIResult SendMsg(std::string InterfaceName, std::string MsgName, std::string inArgs);
		APIResult ReceiveMsg(DBusMessage** recvMsg);
		APIResult SendMsg(DBusMessage* sendMsg);

		pthread_mutex_t* GetDBusLock();

	private:
		APIResult DoAction(DBusMessage*  msg);

	};

	//void * controller_worker(void *arg);
}

#endif /*IPCONTROLLER_H_*/
