/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          IPCStudentAPI.h

Description:

    This file defines class IPCStudentAPI.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef IPCSTUDENTAPI_H_
#define IPCSTUDENTAPI_H_

#include <string>
#include <list>
#include "IPCCommon.h"
#include "IPCAPIBase.h"

using namespace std;

namespace IPCAPI
{
	class IIPCStudentAPICallback;
	class StudentMessageNotify;
	class CExpandTeacherInfoData;

	class IPCStudentAPI : public IPCAPIBase
	{
	private:
		IIPCStudentAPICallback* m_objCallBack;
		StudentMessageNotify* m_MessageNotify;
	private:
		APIResult Initialize();
		APIResult UnInitialize();

		//internal method
//		APIResult SetStudentInfo(std::list<StudentInfo_t> stuInfoList,int& iReturn);

	public:
		IPCStudentAPI();
		virtual ~IPCStudentAPI();

		// Async Call, Check IPCStudentAPICallback.h
//		APIResult ConnectTeacher(std::string strTeacherID/*,StudentInfo_t StuInfo*/);
		APIResult ConnectTeacher(CExpandTeacherInfoData& TeacherInfo);
		APIResult SearchTeacher();
		APIResult SearchLocalProgram(std::string targetFolder, int& OID, int Option = PROGRAMSEARCH_APPEND);
		APIResult SwitchToSES(int& iReturn);

		// Async Call, added by nagp for bata. For function that communicate between App(s).
		APIResult PostMessage(int MessageID, std::string Message);

		// Sync Call
		APIResult DisconnectStudent(int& iReturn);
		APIResult ManualLockLocalStudent(std::string lockPolicy, int& iReturn);
		APIResult ManualUnLockLocalStudent(int& iReturn);
		APIResult SaveLocalTabNavPolicy(std::string strXML, int& iReturn);
		APIResult SaveLocalSchedulePolicy(std::string strXML, int& iReturn);
		APIResult SaveStudentInfo(std::string strXML, int& iReturn);
		APIResult HardWareControl(std::string strXML, int& iReturn);
//		APIResult GetConnectedTeacher(std::string& strTeacherID, int &iReturn);
		APIResult GetConnectedTeacher(CExpandTeacherInfoData& TeacherInfo, int &iReturn);

		APIResult VerifyUserPassword(std::string UserName, std::string Password, int &iReturn);
		APIResult CancelOperation(int OID, int& iReturn);
		APIResult SwitchToNormalOS(int& iReturn);
		APIResult SystemCommand(int Type, std::string Command, int& iReturn);
//		APIResult SetStudentInfo(StudentInfo_t& StuInfo, int& iReturn);

		//Function Method
		APIResult DoAction(std::string strName, std::string inArgs, std::string& outArgs);
		APIResult RegisterCallBack(IIPCStudentAPICallback* callbackObj);


	};
}

#endif /*IPCSTUDENTAPI_H_*/
