/******************************************************************************
 * File Name    : ChangePasswordWindow.cpp
 * Created      : 2008/11/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  :
 ******************************************************************************/
#include <glib/gi18n.h>
#include "SESCommonDef.h"
#include "ChangePasswordWindow.h"
#include "libsesdata.h"
#include "PublicFunc.h"


using namespace std;
using namespace LibSESData;
using namespace IPCAPI;
using namespace LibSESGUI;


#define CHANGE_PASSWORD_WINDOW_BORDER_WIDTH 1
#define CHANGE_PASSWORD_WINDOW_WIDTH 370
#define CHANGE_PASSWORD_WINDOW_HEIGHT 210
#define CHANGE_PASSWORD_WINDOW_ENTRY_WIDTH 180
#define CHANGE_PASSWORD_WINDOW_ENTRY_HEIGHT 25
/******************************************************************************
 * Function Name: ChangePasswordWindow
 * Description  : Constructor of ChangePasswordWindow
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
ChangePasswordWindow::ChangePasswordWindow()
						: m_gWindow (NULL)
						, m_gOriginalPasswordEntry (NULL)
						, m_gNewPasswordEntry (NULL)
						, m_gAuthenPasswordEntry (NULL)
						, m_iClickResult (BUTTON_CLICK_IS_CANCEL)
						, m_iPasswordIsTrue (0)
						, m_inputPasswdNum (0)
{
	CSESLog::WriteLine("ChangePasswordWindow::ChangePasswordWindow>>Start");
	CSESLog::WriteLine("ChangePasswordWindow::ChangePasswordWindow<<End");
}
/******************************************************************************
 * Function Name: ~ChangePasswordWindow
 * Description  : Destructor of ChangePasswordWindow
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
ChangePasswordWindow::~ChangePasswordWindow()
{
	CSESLog::WriteLine("ChangePasswordWindow::~ChangePasswordWindow>>Start");
	Release();
	CSESLog::WriteLine("ChangePasswordWindow::~ChangePasswordWindow<<End");
}
/******************************************************************************
 * Function Name: Init
 * Description  : Initialize ChangePassword window
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : OK		return 0
 * 				  Error		return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ChangePasswordWindow::Init()
{
	CSESLog::WriteLine("ChangePasswordWindow::Init>>Start");
	InitWindow();
	CSESLog::WriteLine("ChangePasswordWindow::Init<<End");
	return 0;
}
/******************************************************************************
 * Function Name: ShowModal
 * Description  : Show ChangePassword window in Modal style
 * Date         : 2008/11/10
 * Parameter    : parentWindow		parent window
 * 				  cb				callback function
 * 				  data				user data
 * Return Code  : OK		return 0
 * 				  Error		return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ChangePasswordWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("ChangePasswordWindow::ShowModal>>Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	if (NULL != cb)
	{
		g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
	}
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("ChangePasswordWindow::ShowModal<<End");
	return 0;
}
/******************************************************************************
 * Function Name: Release
 * Description  : Release memory
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : OK		return 0
 * 				  Error		return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ChangePasswordWindow::Release()
{
	CSESLog::WriteLine("ChangePasswordWindow::Release>>Start");
	if(NULL != m_gWindow)
	{
		gtk_widget_destroy(m_gWindow);
	}
	CSESLog::WriteLine("ChangePasswordWindow::Release<<End");
	return 0;
}
/******************************************************************************
 * Function Name: InitWindow
 * Description  : Initialize main window
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : OK		return 0
 * 				  Error		return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ChangePasswordWindow::InitWindow()
{
	CSESLog::WriteLine("ChangePasswordWindow::InitWindow>>Start");
	GtkWidget* pVbox = NULL;
	GtkWidget* pHbox = NULL;
	GtkWidget* pButton = NULL;
	GtkWidget* pLabel = NULL;
	m_gWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect (m_gWindow, "delete-event", G_CALLBACK (OnWindowClosing), this);
	gtk_container_set_border_width (GTK_CONTAINER (m_gWindow), 1);
	gtk_window_set_position (GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_widget_set_size_request (GTK_WIDGET (m_gWindow), CHANGE_PASSWORD_WINDOW_WIDTH ,CHANGE_PASSWORD_WINDOW_HEIGHT);
	gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_resizable(GTK_WINDOW (m_gWindow), FALSE);
	gtk_window_set_title(GTK_WINDOW (m_gWindow), _("Change Password"));
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Change Password"), "SES");
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);

	string iconPath("");
    iconPath.append(SES_RESOURCE_IMAGE_PATH);
    iconPath.append("shellcontroller_main.png");

    GError* error = NULL;
    gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), SES_SHELL_CONTROLLER_ICON.c_str(), &error);

	pVbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(m_gWindow), pVbox);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 20);

	pLabel = gtk_label_new(_("Old Password:"));
	gtk_misc_set_alignment(GTK_MISC(pLabel), 0.9, 0.5);
	gtk_label_set_width_chars(GTK_LABEL(pLabel), 20);
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 0);

	m_gOriginalPasswordEntry = gtk_entry_new_with_max_length(PASSWORD_MAX_LENGTH);
	gtk_entry_set_visibility(GTK_ENTRY(m_gOriginalPasswordEntry), false);
	gtk_entry_set_invisible_char(GTK_ENTRY(m_gOriginalPasswordEntry), '*');
	gtk_widget_set_size_request(m_gOriginalPasswordEntry, CHANGE_PASSWORD_WINDOW_ENTRY_WIDTH, CHANGE_PASSWORD_WINDOW_ENTRY_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), m_gOriginalPasswordEntry, FALSE, FALSE, 10);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 5);

	pLabel = gtk_label_new(_("New Password:"));
	gtk_label_set_width_chars(GTK_LABEL(pLabel), 20);
	gtk_misc_set_alignment(GTK_MISC(pLabel), 0.9, 0.5);
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 0);

	m_gNewPasswordEntry = gtk_entry_new_with_max_length(PASSWORD_MAX_LENGTH);
	gtk_entry_set_visibility(GTK_ENTRY(m_gNewPasswordEntry), false);
	gtk_entry_set_invisible_char(GTK_ENTRY(m_gNewPasswordEntry), '*');
	gtk_widget_set_size_request(m_gNewPasswordEntry, CHANGE_PASSWORD_WINDOW_ENTRY_WIDTH, CHANGE_PASSWORD_WINDOW_ENTRY_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), m_gNewPasswordEntry, FALSE, FALSE, 10);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 20);

	pLabel = gtk_label_new(_("Confirm New Password:"));
	gtk_label_set_width_chars(GTK_LABEL(pLabel), 20);
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 0);

	m_gAuthenPasswordEntry = gtk_entry_new_with_max_length(PASSWORD_MAX_LENGTH);
	gtk_entry_set_visibility(GTK_ENTRY(m_gAuthenPasswordEntry), false);
	gtk_entry_set_invisible_char(GTK_ENTRY(m_gAuthenPasswordEntry), '*');
	gtk_widget_set_size_request(m_gAuthenPasswordEntry, CHANGE_PASSWORD_WINDOW_ENTRY_WIDTH, CHANGE_PASSWORD_WINDOW_ENTRY_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), m_gAuthenPasswordEntry, FALSE, FALSE, 10);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);

	pButton = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(pButton), "clicked", G_CALLBACK(OnOkCallback), this);
	gtk_widget_set_tooltip_text(pButton, _("OK"));
	gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), pButton, FALSE, FALSE, 10);

	pButton = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(pButton), "clicked", G_CALLBACK(OnCancelCallback), this);
	gtk_widget_set_tooltip_text(pButton, _("Cancel"));
	gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), pButton, FALSE, FALSE, 0);
	CSESLog::WriteLine("ChangePasswordWindow::InitWindow<<End");
	return 0;
}
/******************************************************************************
 * Function Name: OnWindowClosing
 * Description  : Call this function while main window will close
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : TRUE		not close window
 * 				  FALSE		close window
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool ChangePasswordWindow::OnWindowClosing(GtkWidget* gtkwidget, GdkEvent* event, gpointer data)
{
	CSESLog::WriteLine("ChangePasswordWindow::OnWindowClosing>>Start");
	ChangePasswordWindow* ptr = (ChangePasswordWindow*)data;
//	GtkWidget* outDialog = NULL;
//	outDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//						   GTK_DIALOG_MODAL,
//						   GTK_MESSAGE_INFO,
//						   GTK_BUTTONS_YES_NO,
//						   _("Do you want to cancel changing password?"));
//	gtk_window_set_title(GTK_WINDOW(outDialog), "Information");

	int result = CMessageBox::Show(_("Do you want to cancel changing password?"), ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_YES_NO);

	//if(GTK_RESPONSE_YES == gtk_dialog_run(GTK_DIALOG(outDialog)))
	if(GTK_RESPONSE_YES == result)
	{
//		gtk_widget_destroy(outDialog);
		CSESLog::WriteLine("ChangePasswordWindow::OnWindowClosing<<End");
		return false;
	}
	else
	{
//		gtk_widget_destroy(outDialog);
		gtk_widget_grab_focus(ptr->m_gOriginalPasswordEntry);
		CSESLog::WriteLine("ChangePasswordWindow::OnWindowClosing<<End");
		return true;
	}
}
/******************************************************************************
 * Function Name: OnOkCallback
 * Description  : Call this function when clicking OK button
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			OK button
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ChangePasswordWindow::OnOkCallback(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback>>Start");
	ChangePasswordWindow* ptr = (ChangePasswordWindow*)data;
	string nothingString("");
	int iFirstCompareResult = 1;
	int iSecondCompareResult = 1;
	int iThirdCompareResult = 1;
	string firstEntry = gtk_entry_get_text(GTK_ENTRY(ptr->m_gOriginalPasswordEntry));
	PublicFunc::TrimString(firstEntry);
	iFirstCompareResult = firstEntry.compare(nothingString);
	string secondEntry = gtk_entry_get_text(GTK_ENTRY(ptr->m_gNewPasswordEntry));
	PublicFunc::TrimString(secondEntry);
	iSecondCompareResult = secondEntry.compare(nothingString);
	string thirdEntry = gtk_entry_get_text(GTK_ENTRY(ptr->m_gAuthenPasswordEntry));
	PublicFunc::TrimString(secondEntry);
	iThirdCompareResult = thirdEntry.compare(nothingString);
	if(0 != iFirstCompareResult && 0 != iSecondCompareResult && 0 != iThirdCompareResult)
	{
		if(PASSWORD_MIN_LENGTH <= firstEntry.size()&& PASSWORD_MAX_LENGTH >= firstEntry.size())
		{
			string path("");
			int errCode = 0;
			int verifyResult = 0;
			verifyResult = ptr->m_pTeacherAPI->VerifyPassword(path, firstEntry, errCode);
			if(SES_API_SUCCESS == verifyResult)
			{
				if(SES_API_SUCCESS == errCode)
				{
					if(0 == secondEntry.compare(thirdEntry))
					{
						if(PASSWORD_MIN_LENGTH <= secondEntry.size() && PASSWORD_MAX_LENGTH >= secondEntry.size())
						{
							string errorString("");
							int strongPasswordResult = 0;
							strongPasswordResult = CSESDataTools::IsStrongPassword(secondEntry, errorString);
							if(-1 == strongPasswordResult)
							{
								string showString("");
								showString.append(errorString);
								showString.append("\nDo you want to continue?");
								int result = CMessageBox::Show(showString, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_YES_NO);
//								GtkWidget* dialog = gtk_message_dialog_new (GTK_WINDOW(ptr->m_gWindow),
//																			   GTK_DIALOG_MODAL,
//																			   GTK_MESSAGE_INFO,
//																			   GTK_BUTTONS_YES_NO,
//																			   showString.c_str());
								//gtk_window_set_title(GTK_WINDOW(dialog), "Information");
								if(GTK_RESPONSE_YES == result)
								{
									//gtk_widget_destroy(dialog);
									CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
									ptr->ChangPasswordJustify(firstEntry, secondEntry);

								}
								else
								{
									//gtk_widget_destroy(dialog);
									CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
									//gtk_widget_destroy(ptr->m_gWindow);
								}
							}
							else
							{
								CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
								ptr->ChangPasswordJustify(firstEntry, secondEntry);
							}
						}
						else
						{
							string message(_("The length of password should be between 6~64 characters!"));
							CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
							gtk_widget_grab_focus(ptr->m_gNewPasswordEntry);
							CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
						}
					}
					else
					{
						string message(_("The passwords you typed do not match!"));
						CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
						gtk_widget_grab_focus(ptr->m_gAuthenPasswordEntry);
						CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
					}
				}
				else
				{
					string message(_("Old password is wrong!"));
					CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
					gtk_widget_grab_focus(ptr->m_gOriginalPasswordEntry);
					CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
				}
			}
			else if(SES_API_TIME_OUT == verifyResult)
			{
				string message(_("Time out, you may try it again!"));
				CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
				CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
			}
			else
			{
				string message(_("Fail to verify password!"));
				CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
				CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
			}
		}
		else
		{
			string message(_("The length of password should be between 6~64 characters!"));
			CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
		}
	}
	else
	{
		if(0 == iFirstCompareResult)
		{
			string message(_("The old password cannot be empty!"));
			CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			gtk_widget_grab_focus(ptr->m_gOriginalPasswordEntry);
		}
		else if(0 == iSecondCompareResult)
		{
			string message(_("New password cannot be empty!"));
			CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			gtk_widget_grab_focus(ptr->m_gNewPasswordEntry);
		}
		else if(0 == iThirdCompareResult)
		{
			string message(_("The passwords you typed do not match!"));
			CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			gtk_widget_grab_focus(ptr->m_gAuthenPasswordEntry);
		}
		CSESLog::WriteLine("ChangePasswordWindow::OnOkCallback<<End");
	}
}
/******************************************************************************
 * Function Name: OnCancelCallback
 * Description  : Call this function when clicking Cancel button
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			Cancel button
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ChangePasswordWindow::OnCancelCallback(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ChangePasswordWindow::OnCancelCallback>>Start");
	ChangePasswordWindow* ptr = (ChangePasswordWindow*)data;
//	GtkWidget* outDialog = NULL;
//	outDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//						   GTK_DIALOG_MODAL,
//						   GTK_MESSAGE_INFO,
//						   GTK_BUTTONS_YES_NO,
//						   _("Do you want to cancel changing password?"));
	//gtk_window_set_title(GTK_WINDOW(outDialog), "Information");
	string message(_("Do you want to cancel changing password?"));
	int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
	if(GTK_RESPONSE_YES == result)
	{
		//gtk_widget_destroy(outDialog);
		gtk_widget_destroy(ptr->m_gWindow);
		CSESLog::WriteLine("ChangePasswordWindow::OnCancelCallback<<End");
	}
	else
	{
		//gtk_widget_destroy(outDialog);
		gtk_widget_grab_focus(ptr->m_gOriginalPasswordEntry);
		CSESLog::WriteLine("ChangePasswordWindow::OnCancelCallback<<End");
	}
}
/******************************************************************************
 * Function Name: IsPasswordTrue
 * Description  : return the value whether password is true or not
 * Date         : 2008/11/10
 * Parameter    :
 * Return Code  : TURE			password is true
 * 				  FALSE			password is false
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool ChangePasswordWindow::IsPasswordTrue()
{
	CSESLog::WriteLine("ChangePasswordWindow::IsPasswordTrue>>Start");
	CSESLog::WriteLine("ChangePasswordWindow::IsPasswordTrue<<End");
	return m_iPasswordIsTrue;
}
/******************************************************************************
 * Function Name: GetResult
 * Description  : Get the clicking result
 * Date         : 2008/11/10
 * Parameter    :
 * Return Code  : 0			buttonclick is Cancel
 * 				  1			buttonclick is OK
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ChangePasswordWindow::GetResult()
{
	CSESLog::WriteLine("ChangePasswordWindow::GetResult>>Start");
	CSESLog::WriteLine("ChangePasswordWindow::GetResult<<End");
	return m_iClickResult;
}
/******************************************************************************
 * Function Name: ChangPasswordJustify
 * Description  : Justify whether changing password
 * Date         : 2008/11/10
 * Parameter    : message		the string which will be showed on dialog
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ChangePasswordWindow::ChangPasswordJustify(string& oldPassword, string& newPasswword)
{
	CSESLog::WriteLine("ChangePasswordWindow::ChangPasswordJustify>>Start");
	int changePasswordErrCode = 0;
	int changePasswordResult = 0;
	changePasswordResult = m_pTeacherAPI->ChangePassword(oldPassword, newPasswword, changePasswordErrCode);
	if(SES_API_SUCCESS == changePasswordResult)
	{
		if(SES_API_SUCCESS != changePasswordErrCode)
		{
			string message(_("Fail to change password!"));
			CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
		}
		else
		{
			gtk_widget_destroy(m_gWindow);
		}
	}
	else if(SES_API_TIME_OUT == changePasswordResult)
	{
		string message(_("Time out, you may try it again!"));
		CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
	}
	else
	{
		string message(_("Fail to change password!"));
		CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
	}
	CSESLog::WriteLine("ChangePasswordWindow::ChangPasswordJustify<<End");
}
