/*
 * MainIconVeiwOperation.cpp
 *
 *  Created on: 2008-12-9
 *      Author: hm
 */

#include "MainIconVeiwOperation.h"

MainIconVeiwOperation::MainIconVeiwOperation(GtkWidget* iconView)
{
	if(GTK_ICON_VIEW(iconView))
	{
		m_iconView = iconView;
		g_object_ref((gpointer)m_iconView);
	}
	else
	{
		m_iconView = NULL;
	}
}

MainIconVeiwOperation::~MainIconVeiwOperation()
{
	if(m_iconView)
	{
		g_object_unref((gpointer)m_iconView);
		m_iconView = NULL;
	}
}

GList* MainIconVeiwOperation::MainViewGetSelectedItems()
{
	GList* ret = NULL;

	if(m_iconView)
	{
		ret = gtk_icon_view_get_selected_items (GTK_ICON_VIEW(m_iconView));
	}

	return ret;
}

GtkTreeModel* MainIconVeiwOperation::MainViewGetModel()
{
	GtkTreeModel* ret = NULL;

	if(m_iconView)
	{
		ret = gtk_icon_view_get_model(GTK_ICON_VIEW(m_iconView));
	}

	return ret;
}

void MainIconVeiwOperation::MainViewSelectAll()
{
	if(m_iconView)
	{
		gtk_icon_view_select_all(GTK_ICON_VIEW(m_iconView));
	}
}

void MainIconVeiwOperation::MainViewUnselectAll()
{
	if(m_iconView)
	{
		gtk_icon_view_unselect_all(GTK_ICON_VIEW(m_iconView));
	}
}

void MainIconVeiwOperation::MainViewSelectPath(GList *pathList)
{
	if(m_iconView)
	{
		GtkTreePath* treepath = NULL;

		this->MainViewUnselectAll();

		for(GList* tmpGlist = g_list_first(pathList); NULL != tmpGlist; tmpGlist = g_list_next(tmpGlist))
		{
			treepath = (GtkTreePath*)(tmpGlist->data);

			if(treepath)
			{
				gtk_icon_view_select_path(GTK_ICON_VIEW(m_iconView), treepath);
			}
		}
	}
}

int MainIconVeiwOperation::MainViewGetSelectedItemsCount()
{
    int ret = 0;
    GList* pList = MainViewGetSelectedItems();
    if(NULL != pList)
    {
        ret = g_list_length(pList);

        g_list_foreach (pList, (GFunc)gtk_tree_path_free, NULL);
        g_list_free (pList);
    }

    return ret;
}
