/******************************************************************************
 * File Name    : ShellControllerApp.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : Initialize and show ShellControllerApp
 ******************************************************************************/
#include "ShellControllerApp.h"
#include "libsesdata.h"
//#include "IPCTeacherAPI.h"
using namespace LibSESData;
using namespace IPCAPI;

namespace ShellController
{

ShellControllerApp::ShellControllerApp ()
{
	CSESLog::WriteLine("ShellControllerApp::ShellControllerApp >>Start");
	m_pShellController = NULL;
	//m_pPassword = NULL;
	//m_pImportCA = NULL;
//	m_pSelectClass = NULL;
	CSESLog::WriteLine("ShellControllerApp::ShellControllerApp <<End");
}
/******************************************************************************
 * Function Name: Init
 * Description  : Initialization of ShellControllerApp
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerApp::Init()
{
	CSESLog::WriteLine("ShellControllerApp::Init>>Start");
	int ret = 0;

	if (!g_thread_supported ())
	{
		g_thread_init (NULL);
	}
	gdk_threads_init();
	gtk_init(NULL, NULL);

//	m_pImportCA = new ImportCAWindow();
//	m_pImportCA->Init();
//	m_pPassword = new PassWordWindow();
//	m_pPassword->Init();

	m_pShellController = new ShellControllerWindow ();
	if ( NULL != m_pShellController )
	{
		ret = m_pShellController->Init ();
	}

	CSESLog::WriteLine("ShellControllerApp::Init<<End");
	return ret;
}
/******************************************************************************
 * Function Name: Run
 * Description  : Run ShellControllerApp
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerApp::Run()
{
	CSESLog::WriteLine("ShellControllerApp::Run>>Start");
//	m_pImportCA->Show();
//	m_pPassword->Show();
	m_pShellController->Show();
	gdk_threads_enter();
	gtk_main ();
	gdk_threads_leave();
	CSESLog::WriteLine("ShellControllerApp::Run<<End");
	return 0;
}
/******************************************************************************
 * Function Name: Release
 * Description  : Release ShellControllerApp
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerApp::Release()
{
	//TODO : jinxin
	// 1.review check null first.
	// 2.rename this func// Done
	CSESLog::WriteLine("ShellControllerApp::release>>Start");
//	if (NULL != m_pImportCA)
//	{
//		delete m_pImportCA;
//		m_pImportCA = NULL;
//	}
	if (NULL != m_pShellController)
	{
		delete m_pShellController;
		m_pShellController = NULL;
	}
//	if (NULL != m_pPassword)
//	{
//		delete m_pPassword;
//		m_pPassword = NULL;
//	}
	CSESLog::WriteLine("ShellControllerApp::release<<End");
	return 0;
}

}
