/******************************************************************************
 * File Name    : StudentDetailedInfoWindow.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : Show students' detail information
 ******************************************************************************/
#include <glib/gi18n.h>
#include <stdio.h>
#include <stdlib.h>
#include <sstream>
#include <list>
#include "IPCTeacherAPI.h"
#include "LockTimeSection.h"
#include "StudentDetailedInfoWindow.h"
#include "libsesdata.h"
#include "SESCommonDef.h"
#include "Lock.h"
#include "AutoLock.h"
#include "ManualLockInfo.h"
#include "PolicySettingData.h"
using namespace IPCAPI;
using namespace LibSESData;

#define STUDENT_INFO_WINDOW_TEXT_VIEW_WIDTH 200
#define STUDENT_INFO_WINDOW_TEXT_VIEW_HEIGHT 140
#define STUDENT_INFO_WINDOW_BORDER_WIDTH 1
#define STUDENT_INFO_WINDOW_WIDTH 360
#define STUDENT_INFO_WINDOW_HEIGHT 390

/******************************************************************************
 * Function Name: StudentDetailedInfoWindow
 * Description  : The constructor of StudentDetailedInfoWindow
 * Date         : 2008/9/10
 * Parameter    : pStudent	 the selected student
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
StudentDetailedInfoWindow::StudentDetailedInfoWindow (tagStudent_t* pStudent)
	:m_gWindow (NULL)
{
	CSESLog::WriteLine("StudentDetailedInfoWindow::StudentDetailedInfoWindow>>Start");
	if (NULL == pStudent)
	{
		m_pStudent = new tagStudent_t();

	}
	else
	{
		m_pStudent = new tagStudent_t ();
		m_pStudent->username = pStudent->username;
		m_pStudent->studentID = pStudent->studentID;
		m_pStudent->hostname = pStudent->hostname;
		m_pStudent->IP = pStudent->IP;
		m_pStudent->start_time = pStudent->start_time;
		m_pStudent->bLocked = pStudent->bLocked;
		m_pStudent->status = pStudent->status;
		m_pStudent->displayName = pStudent->displayName;
		m_pStudent->deployerName = pStudent->deployerName;
		m_pStudent->lastUpdateTime = pStudent->lastUpdateTime;
	}
	//m_gWindow = NULL;
	//m_gVbox = NULL;
	//m_gHbox = NULL;
	//m_gOKBtn = NULL;
	//m_gAlignment = NULL;
	for (int i = 0; i < NEW_STUDENT_LABEL_NUM; i++)
	{
		m_gLabel[i] = NULL;
	}
	CSESLog::WriteLine("StudentDetailedInfoWindow::StudentDetailedInfoWindow<<End");
}
/******************************************************************************
 * Function Name: ~StudentDetailedInfoWindow
 * Description  : The destructor of StudentDetailedInfoWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
StudentDetailedInfoWindow::~StudentDetailedInfoWindow()
{
	//Close ();
}
/******************************************************************************
 * Function Name: Init
 * Description  : To initialize the StudentDetailedInfoWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK			return 0;
 * 				  ERROR	 		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int StudentDetailedInfoWindow::Init()
{
	CSESLog::WriteLine("StudentDetailedInfoWindow::Init>>Start");
	gtk_init (NULL, NULL);
	const char* strInfo[NEW_STUDENT_LABEL_NUM]={"Student ID: ", "Student Name: ", "Machine Name: ", "Lock Status: ",
			"Policy Update Time: ", "SES Online Time: ", "Deployer Name: "};
	m_gWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (m_gWindow), _("Student Detailed Information"));
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Student Detailed Information"), "SES");
    gtk_container_set_border_width (GTK_CONTAINER (m_gWindow), STUDENT_INFO_WINDOW_BORDER_WIDTH);
    gtk_widget_set_size_request (GTK_WIDGET (m_gWindow), STUDENT_INFO_WINDOW_WIDTH, STUDENT_INFO_WINDOW_HEIGHT);
    gtk_window_set_resizable (GTK_WINDOW (m_gWindow), FALSE);
    gtk_window_set_position(GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
    gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);
    gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);

    GtkWidget* pMainVbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (m_gWindow), pMainVbox);

    GtkWidget* pMarginHbox = gtk_hbox_new(false, 0);
    gtk_widget_set_size_request(pMarginHbox, 360, 5);
    gtk_box_pack_start (GTK_BOX (pMainVbox), pMarginHbox, FALSE, FALSE, 0);

    for (int i = 0; i < NEW_STUDENT_LABEL_NUM; i++)
    {
//    	GtkWidget* pAlignment = gtk_alignment_new (0.2, 0, 0, 0);
//        gtk_box_pack_start (GTK_BOX (pMainVbox), pAlignment, FALSE, FALSE, 5);
//        gtk_widget_show (pAlignment);
        GtkWidget* pHbox = gtk_hbox_new(false, 0);
        gtk_box_pack_start (GTK_BOX (pMainVbox), pHbox, FALSE, FALSE, 5);
    	m_gLabel[i] = gtk_label_new (strInfo[i]);
    	gtk_misc_set_alignment(GTK_MISC(m_gLabel[i]), 0, 0.5);
    	gtk_label_set_max_width_chars(GTK_LABEL(m_gLabel[i]), 38);
    	    //gtk_label_set_justify(GTK_LABEL(pNewStuNameLabel), GTK_JUSTIFY_LEFT);
    	gtk_label_set_ellipsize(GTK_LABEL(m_gLabel[i]), PANGO_ELLIPSIZE_END);
    	gtk_widget_set_tooltip_text(m_gLabel[i], gtk_label_get_text(GTK_LABEL(m_gLabel[i])));
    	gtk_box_pack_start (GTK_BOX (pHbox), m_gLabel[i], false, false, 10);
    }
	string showText("");

	int errCode = 0;
	IPCAPI::tagStudent_t tmpStudent; //= new tagStudent_t();
	m_pTeacherAPI->GetStudentStatus(m_pStudent->studentID, tmpStudent, errCode);

	m_pStudent->status = tmpStudent.status;
	m_pStudent->deployerName = tmpStudent.deployerName;
	m_pStudent->lastUpdateTime = tmpStudent.lastUpdateTime;


    if (SES_STU_DISCONNECT == m_pStudent->status)
	{
    	showText = "Student ID: ";
    	showText += m_pStudent->studentID;
		gtk_label_set_text(GTK_LABEL (m_gLabel[0]), showText.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[0], showText.c_str());
		showText = "Student Name: ";
		showText += m_pStudent->username;
		gtk_label_set_text(GTK_LABEL (m_gLabel[1]), showText.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[1], showText.c_str());
		gtk_label_set_text(GTK_LABEL (m_gLabel[2]), _("Machine Name: "));

		if(m_pStudent->status)
		gtk_label_set_text(GTK_LABEL (m_gLabel[3]), _("Lock Status: "));
//		if(pTmpStudent.status)
//		{
//
//		}
//		else
//		{
//
//		}

//		showText = "Policy Update Time: ";
		string lastUpdateTimeStr("");
		long int updateTime = /*now -*/ m_pStudent->lastUpdateTime;

		lastUpdateTimeStr = FormatLocalTime(updateTime);
		lastUpdateTimeStr = "Policy Update Time: "+ lastUpdateTimeStr;
		gtk_label_set_text(GTK_LABEL (m_gLabel[4]), lastUpdateTimeStr.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[4], lastUpdateTimeStr.c_str());
		//gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _("Policy Update Status: "));
		gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _("SES Online Time: "));

		string compareString(LOCALADMIN);
		if(0 == (m_pStudent->username).compare(compareString))
		{
			showText = _("Deployer Name: ");
			showText += _(LOCALADMIN);
			gtk_label_set_text(GTK_LABEL (m_gLabel[6]), showText.c_str());
			gtk_widget_set_tooltip_text(m_gLabel[6], showText.c_str());
		}
		else
		{
			showText = _("Deployer Name: ");
			showText += m_pStudent->deployerName;
			gtk_label_set_text(GTK_LABEL (m_gLabel[6]), showText.c_str());
			gtk_widget_set_tooltip_text(m_gLabel[6], showText.c_str());
		}

	}
    else
	{
    	stringstream sstime("");
    	string sstimeStr("");
		time_t now = time(NULL);
		long int timeDistance = now - m_pStudent->start_time;
		sstimeStr = FormatTime (timeDistance);

		showText = _("Student ID: ");
		showText += m_pStudent->studentID;
		gtk_label_set_text(GTK_LABEL (m_gLabel[0]), showText.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[0], showText.c_str());

		showText = _("Student Name: ");
		showText += m_pStudent->username;
		gtk_label_set_text(GTK_LABEL (m_gLabel[1]), showText.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[1], showText.c_str());

		showText = _("Machine Name: ");
		showText += m_pStudent->hostname;
		gtk_label_set_text(GTK_LABEL (m_gLabel[2]), showText.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[2], showText.c_str());
		if(1 == m_pStudent->bLocked)
		{
			gtk_label_set_text(GTK_LABEL (m_gLabel[3]), _("Lock Status: Lock"));
			gtk_widget_set_tooltip_text(m_gLabel[3], _("Lock Status: Lock"));
		}
		else
		{
			gtk_label_set_text(GTK_LABEL (m_gLabel[3]), _("Lock Status: Unlock"));
			gtk_widget_set_tooltip_text(m_gLabel[3], _("Lock Status: Unlock"));
		}

		//TODO : No data now
//		stringstream lastUpdateTime("");
		string lastUpdateTimeStr("");

		long int updateTime = /*now -*/ m_pStudent->lastUpdateTime;

		lastUpdateTimeStr = FormatLocalTime(updateTime);
		lastUpdateTimeStr = _("Policy Update Time: ")+ lastUpdateTimeStr;



//		lastUpdateTime << "Policy Update Time: ";
//		lastUpdateTime << m_pStudent->lastUpdateTime;





		gtk_label_set_text(GTK_LABEL (m_gLabel[4]), lastUpdateTimeStr.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[4], lastUpdateTimeStr.c_str());

//		switch(m_pStudent->status)
//		{
//		case 0:
//			gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _(("Policy Update Status: LOCK")));
//			break;
//		case 1:
//			gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _(("Policy Update Status: UNLOCK")));
//			break;
//		case 2:
//			gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _(("Policy Update Status: AUTO_LOCK")));
//			break;
//		case 3:
//			gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _(("Policy Update Status: AUTO_UNLOCK")));
//			break;
//		case 4:
//			gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _(("Policy Update Status: MANUAL_LOCK")));
//			break;
//		case 5:
//			gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _(("Policy Update Status: MANUAL_UNLOCK")));
//			break;
//		case 6:
//			gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _(("Policy Update Status: DISCONNECT")));
//			break;
//		case 7:
//			gtk_label_set_text(GTK_LABEL (m_gLabel[5]), _(("Policy Update Status: CONNECT")));
//			break;
//		default:
//			break;
//		}
		showText = _("SES Online Time: ");
		showText += sstimeStr;
		gtk_label_set_text(GTK_LABEL (m_gLabel[5]), showText.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[5], showText.c_str());

		//add by lfeng
		showText = _("Deployer Name: ");
		showText += m_pStudent->deployerName;
		gtk_label_set_text(GTK_LABEL (m_gLabel[6]), showText.c_str());
		gtk_widget_set_tooltip_text(m_gLabel[6], showText.c_str());
	}

	GtkWidget* scrolled_window = CreateText();

	GtkWidget* pHbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (pMainVbox), pHbox, FALSE, FALSE, 10);

    gtk_box_pack_start(GTK_BOX(pHbox), scrolled_window, false, false, 10);

    GtkWidget* pVbox= gtk_vbox_new (FALSE, 0);
    gtk_box_pack_end (GTK_BOX (pMainVbox), pVbox, FALSE, FALSE, 10);
    // CreateText();


    GtkWidget* pAlignment = gtk_alignment_new (0.5, 0, 0, 0);
    gtk_box_pack_start (GTK_BOX (pVbox), pAlignment, FALSE, FALSE, 0);


    GtkWidget* pButton = gtk_button_new_with_label (_("OK"));
    g_signal_connect(G_OBJECT(pButton), "clicked", G_CALLBACK(OnOKCallback), this);
    gtk_widget_set_size_request (pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
    gtk_widget_set_tooltip_text(pButton, _("OK"));
    gtk_container_add (GTK_CONTAINER (pAlignment), pButton);
    CSESLog::WriteLine("StudentDetailedInfoWindow::Init<<End");
    return 0;
}
/******************************************************************************
 * Function Name: ShowModal
 * Description  : Make the StudentDetailedInfoWindow in modal style
 * Date         : 2008/9/10
 * Parameter    : parentWindow			parent GtkWidget
 * 				  cb					callback function
 * 				  data					user data
 * Return Code  : OK			return 0;
 * 				  ERROR	 		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
gint StudentDetailedInfoWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("StudentDetailedInfoWindow::ShowModal>>Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	if (NULL!=cb)
	{
		g_signal_connect (G_OBJECT (m_gWindow), "destroy", G_CALLBACK (cb), data);
	}
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("StudentDetailedInfoWindow::ShowModal<<End");
	return 0;
}
/******************************************************************************
 * Function Name: StuInfoWinClose
 * Description  : Close the StudentDetailedInfoWindow
 * Date         : 2008/9/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data					user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void StudentDetailedInfoWindow::OnOKCallback(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("StudentDetailedInfoWindow::StuInfoWinClose>>Start");
	StudentDetailedInfoWindow* ptr = (StudentDetailedInfoWindow*)data;
	gtk_widget_destroy(ptr->m_gWindow);
	CSESLog::WriteLine("StudentDetailedInfoWindow::StuInfoWinClose<<End");
}

/******************************************************************************
 * Function Name: CreateText
 * Description  : Create ScrollWindow
 * Date         : 2008/10/14
 * Parameter    : void
 * Return Code  : gtkwidget			the GtkWidget which contains Lock Policy
 * Author       : wang-l@neusoft.com
 ******************************************************************************/
GtkWidget* StudentDetailedInfoWindow::CreateText()
{
   GtkWidget* pScrolled_window;
   pScrolled_window = gtk_scrolled_window_new (NULL, NULL);
   gtk_widget_set_size_request(pScrolled_window, 335, 140);
   string studentID = m_pStudent->studentID;
	LibSESData::CLockScheduleData lockSchedule;
	int error;
	m_pTeacherAPI->GetStudentLockPolicy(studentID,lockSchedule,error);
	if(error == SES_API_SUCCESS)
   	{
		GtkWidget* pGtkWidget;
		Lock* lock;
		if(lockSchedule.IsManualLockEnable())
			{
				lock =  new ManualLock(lockSchedule);
				pGtkWidget = lock->CreateChild();
				gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(pScrolled_window), pGtkWidget);
			}
		else if(lockSchedule.IsAutoLockEnable())
			{
				lock = new AutoLock(lockSchedule);
				pGtkWidget = lock->CreateChild();
				gtk_container_add(GTK_CONTAINER(pScrolled_window),pGtkWidget);
			}
		else
			{
				lock = new Lock(lockSchedule);
				pGtkWidget = lock->CreateChild();
				gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(pScrolled_window), pGtkWidget);
			}
   	}
	else
	{
		GtkWidget* pGtkWidget;
		pGtkWidget = gtk_text_view_new ();
		gtk_container_add(GTK_CONTAINER(pScrolled_window),pGtkWidget);
	}
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (pScrolled_window),
						   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_widget_show_all (pScrolled_window);
   return pScrolled_window;
}

std::string StudentDetailedInfoWindow::FormatLocalTime(long int time)
{
	tm* tmtime = localtime(&(time));
	char * pChar = asctime(tmtime);
	string strResult(pChar);
	if( strResult.size() == 0 )
	{
		return "";
	}
	else
	{
		return strResult.substr(0,strResult.size()-1);
	}
}

std::string StudentDetailedInfoWindow::FormatTime(long int time)
{
	stringstream outputStream("");
	string outputStr("");
	int hour = time/3600;
	int tempTime = time%3600;
	int minute = tempTime/60;
	int second = tempTime%60;

	outputStream.width(2);
	outputStream.fill('0');
	outputStream << hour;
	outputStream << "";

	outputStr += outputStream.str();
	outputStream.str("");
	outputStr += ":";

	outputStream.width(2);
	outputStream.fill('0');
	outputStream << minute;
	outputStream << "";

	outputStr += outputStream.str();
	outputStream.str("");
	outputStr += ":";

	outputStream.width(2);
	outputStream.fill('0');
	outputStream << second;
	outputStream << "";

	outputStr += outputStream.str();
	outputStream.str("");

	return outputStr;
}
